VERSION 5.00
Begin VB.Form FS300_Basic_Measurement_Form1 
   Caption         =   "FS300_Basic_Measurement"
   ClientHeight    =   4560
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7230
   LinkTopic       =   "Form1"
   ScaleHeight     =   4560
   ScaleWidth      =   7230
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox SamplesReturned 
      Height          =   285
      Left            =   3840
      TabIndex        =   13
      Text            =   "0"
      Top             =   3960
      Width           =   2055
   End
   Begin VB.TextBox StopFrequency 
      Height          =   285
      Left            =   240
      TabIndex        =   11
      Text            =   "300000000"
      Top             =   2280
      Width           =   2055
   End
   Begin VB.TextBox StartFrequency 
      Height          =   285
      Left            =   240
      TabIndex        =   9
      Text            =   "100000"
      Top             =   1680
      Width           =   2055
   End
   Begin VB.TextBox SweepPoints 
      Height          =   285
      Left            =   240
      TabIndex        =   8
      Text            =   "100"
      Top             =   2880
      Width           =   2055
   End
   Begin VB.TextBox referenceLevel 
      Height          =   285
      Left            =   240
      TabIndex        =   6
      Text            =   "-20"
      Top             =   1080
      Width           =   2055
   End
   Begin VB.TextBox ErroMsgText 
      Height          =   3015
      Left            =   3600
      TabIndex        =   3
      Top             =   360
      Width           =   3375
   End
   Begin VB.TextBox ResourceNameText 
      Height          =   285
      Left            =   240
      MaxLength       =   23
      TabIndex        =   2
      Text            =   "USB::0xAAD::0x6::100015"
      Top             =   360
      Width           =   2055
   End
   Begin VB.CommandButton Ok 
      Caption         =   "Ok"
      Height          =   615
      Left            =   6480
      TabIndex        =   0
      Top             =   3720
      Width           =   615
   End
   Begin VB.Label SamplesReturnedName 
      Caption         =   "Samples Returned"
      Height          =   255
      Left            =   3840
      TabIndex        =   14
      Top             =   3720
      Width           =   1575
   End
   Begin VB.Label StopFrequencyName 
      Caption         =   "Stop Frequency"
      Height          =   255
      Index           =   1
      Left            =   240
      TabIndex        =   12
      Top             =   2040
      Width           =   1215
   End
   Begin VB.Label StartFrequencyName 
      Caption         =   "Start Frequency"
      Height          =   255
      Index           =   0
      Left            =   240
      TabIndex        =   10
      Top             =   1440
      Width           =   1215
   End
   Begin VB.Label SweepPointsName 
      Caption         =   "SweepPoints"
      Height          =   255
      Left            =   240
      TabIndex        =   7
      Top             =   2640
      Width           =   1215
   End
   Begin VB.Label Reflevel 
      Caption         =   "Reflevel"
      Height          =   255
      Index           =   1
      Left            =   240
      TabIndex        =   5
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label Error_Msg 
      Caption         =   "Error Message"
      Height          =   255
      Left            =   3600
      TabIndex        =   4
      Top             =   120
      Width           =   1335
   End
   Begin VB.Label ResourceName 
      Caption         =   "ResourceName"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "FS300_Basic_Measurement_Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*****************************************************************************/
'**
'@file         FS300_Basic_Measurement.c
'@copyright    (c) Rohde & Schwarz GmbH & Co. KG, Munich
'@version       Revision: 1.1, 05/2004

'@author       W. Blanz
'@responsible  W. Blanz
'*
'@language     Visual Basic
'*
'@description    Sample to setup the FS300 Spectrum Analyser
'                and perform a measurement. With parameters
'                entered  by the user interface.

'@see
'*
'@history

'    05 Dez 2003:    1.0 Initial version
'    18 May 2004:    1.1 modified user interface
'*
'@info
'    The example software was tested with the revision 1.6 of the
'    rssifs VXI PnP driver and FS300 Release 2.1 and 2.2.

'*
'*
'*
'*******************************************************************************
'******************************************************************************/


' error/status messages
Private Sub PrintError(iError As Long, sid As Long)

Dim iLen As Long
Dim ec As Long
Dim error_message As String

If iError < 0 Then
 
    ec = 0
    error_message = String(256, 0)
    rssifs_error_message sid, iError, error_message
    MsgBox "Error: " & error_message
    
    rssifs_error_query sid, ec, error_message
    If ec <> 0 Then MsgBox "Device error: " & error_message

End If

End Sub

Private Sub Label1_Click()

End Sub

Private Sub Ok_Click()
    Dim Status As Long
    Dim instrumentHandle As Long
    Dim queryResult As String
    Dim textBoxRow As Integer
    Dim traceData(1024) As Double
    Dim ReturnedSamples As Long
    
queryResult = String(256, " ")
  
  
  ' Open Device Session (Use your FS300 serial number here
  Status = rssifs_init(ResourceNameText.Text, 1, 1, instrumentHandle)
  If Status = 0 Then
    ErroMsgText.Text = ErroMsgText.Text + "Device Opened!" + vbCrLf
  Else
    ErroMsgText.Text = ErroMsgText.Text + "Device Opening Failed!" + vbCrLf
    Exit Sub
  End If

' Set Reference Level
Status = rssifs_confRefLevel(instrumentHandle, referenceLevel.Text)
PrintError Status, instrumentHandle ' display device/driver errors
    
' Set Start and Stop Frequency
Status = rssifs_confStartStopFrq(instrumentHandle, 0, StartFrequency.Text, StopFrequency.Text)
PrintError Status, instrumentHandle ' display device/driver errors

' Set RBW and VBW to AUTO Mode
Status = rssifs_configureBandwidth(instrumentHandle, 0, 0)
PrintError Status, instrumentHandle ' display device/driver errors

' Stop actual Sweep
Status = rssifs_actAbort(instrumentHandle)
PrintError Status, instrumentHandle ' display device/driver errors

' Set Sweep Points
Status = rssifs_confSweepPoints(instrumentHandle, SweepPoints.Text)
PrintError Status, instrumentHandle ' display device/driver errors

' Start Actual Sweep
Status = rssifs_actSendTrg(instrumentHandle)
PrintError Status, instrumentHandle ' display device/driver errors

' Read One Complete Trace
Status = rssifs_readCompleteSweepData(instrumentHandle, traceData(0), ReturnedSamples)
PrintError Status, instrumentHandle ' display device/driver errors
If Status = 0 Then
    SamplesReturned = CStr(ReturnedSamples)
End If

' Close Device
Status = rssifs_close(instrumentHandle)
If Status = 0 Then
    ErroMsgText.Text = ErroMsgText.Text + "Device Closed!" + vbCrLf
End If
End Sub

Private Sub RefLevelText_Change()

End Sub

Private Sub SweepPointsText1_Change()

End Sub

